/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.util;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public final class Stats {
    private HashMap properties = new HashMap(250, 0.5f);
    static final Comparator STRING_COMPARATOR = new Comparator(){

        public int compare(Object ob1, Object ob2) {
            return ((String)ob1).compareTo((String)ob2);
        }
    };

    public synchronized void resetSession() {
        Set key_set = this.properties.keySet();
        String[] keys = new String[key_set.size()];
        int index = 0;
        Iterator it = key_set.iterator();
        while (it.hasNext()) {
            keys[index] = (String)it.next();
            ++index;
        }
        for (int i = 0; i < keys.length; ++i) {
            if (!keys[i].startsWith("{session}")) continue;
            IntegerStat stat = (IntegerStat)this.properties.get(keys[i]);
            stat.value = 0L;
        }
    }

    public synchronized void add(int value, String stat_name) {
        IntegerStat stat = (IntegerStat)this.properties.get(stat_name);
        if (stat != null) {
            stat.value += (long)value;
        } else {
            stat = new IntegerStat();
            stat.value = value;
            this.properties.put(stat_name, stat);
        }
    }

    public synchronized void increment(String stat_name) {
        IntegerStat stat = (IntegerStat)this.properties.get(stat_name);
        if (stat != null) {
            ++stat.value;
        } else {
            stat = new IntegerStat();
            stat.value = 1L;
            this.properties.put(stat_name, stat);
        }
    }

    public synchronized void decrement(String stat_name) {
        IntegerStat stat = (IntegerStat)this.properties.get(stat_name);
        if (stat != null) {
            --stat.value;
        } else {
            stat = new IntegerStat();
            stat.value = -1L;
            this.properties.put(stat_name, stat);
        }
    }

    public synchronized Object get(String stat_name) {
        IntegerStat stat = (IntegerStat)this.properties.get(stat_name);
        if (stat != null) {
            return new Long(stat.value);
        }
        return null;
    }

    public synchronized void set(int value, String stat_name) {
        IntegerStat stat = (IntegerStat)this.properties.get(stat_name);
        if (stat != null) {
            stat.value = value;
        } else {
            stat = new IntegerStat();
            stat.value = value;
            this.properties.put(stat_name, stat);
        }
    }

    public synchronized String[] keyList() {
        Set key_set = this.properties.keySet();
        String[] keys = new String[key_set.size()];
        int index = 0;
        Iterator it = key_set.iterator();
        while (it.hasNext()) {
            keys[index] = (String)it.next();
            ++index;
        }
        Arrays.sort(keys, STRING_COMPARATOR);
        return keys;
    }

    public synchronized String statString(String key) {
        IntegerStat stat = (IntegerStat)this.properties.get(key);
        return Long.toString(stat.value);
    }

    public synchronized String toString() {
        String[] keys = this.keyList();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < keys.length; ++i) {
            IntegerStat stat = (IntegerStat)this.properties.get(keys[i]);
            buf.append(keys[i]);
            buf.append(": ");
            buf.append(stat.value);
            buf.append('\n');
        }
        return new String(buf);
    }

    public synchronized void printTo(PrintStream out) {
        String[] keys = this.keyList();
        for (int i = 0; i < keys.length; ++i) {
            IntegerStat stat = (IntegerStat)this.properties.get(keys[i]);
            out.print(keys[i]);
            out.print(": ");
            out.println(stat.value);
        }
    }

    private static class IntegerStat {
        long value;

        private IntegerStat() {
        }
    }
}

